/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.proxy;

import com.google.common.base.Predicates;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Queue;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderLevelLastEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import org.objectweb.asm.Type;
import org.zeith.hammerlib.HammerLib;
import org.zeith.hammerlib.api.forge.ContainerAPI;
import org.zeith.hammerlib.api.inv.IScreenContainer;
import org.zeith.hammerlib.api.lighting.ColoredLight;
import org.zeith.hammerlib.api.lighting.HandleLightOverrideEvent;
import org.zeith.hammerlib.api.lighting.impl.IGlowingEntity;
import org.zeith.hammerlib.client.render.tile.IBESR;
import org.zeith.hammerlib.client.render.tile.TESRBase;
import org.zeith.hammerlib.core.adapter.ConfigAdapter;
import org.zeith.hammerlib.event.client.ClientLoadedInEvent;
import org.zeith.hammerlib.net.Network;
import org.zeith.hammerlib.net.packets.PacketPlayerReady;
import org.zeith.hammerlib.net.packets.PingServerPacket;
import org.zeith.hammerlib.proxy.HLCommonProxy;
import org.zeith.hammerlib.util.java.Cast;
import org.zeith.hammerlib.util.java.ReflectionUtil;
import org.zeith.hammerlib.util.mcf.LogicalSidePredictor;

public class HLClientProxy
extends HLCommonProxy {
    public static Map<ParticleRenderType, Queue<Particle>> PARTICLE_MAP;
    private Map<String, String> languageList;
    int pingTimer;
    boolean renderedWorld = false;
    private boolean renderF3;

    @Override
    public void clientSetup() {
        MenuScreens.m_96206_(ContainerAPI.TILE_CONTAINER, (ctr, inv, txt) -> Cast.optionally(ctr, IScreenContainer.class).map(c -> c.openScreen(inv, txt)).orElse(null));
        PARTICLE_MAP = ReflectionUtil.getField(Minecraft.m_91087_().f_91061_, 2, Map.class).orElseGet(Collections::emptyMap);
    }

    public static Stream<Particle> streamParticles() {
        return PARTICLE_MAP.values().stream().flatMap(Collection::stream);
    }

    @Override
    public Stream<ColoredLight> getGlowingParticles(float partialTicks) {
        return HLClientProxy.streamParticles().map(particle -> {
            ColoredLight l = null;
            IGlowingEntity ent = Cast.cast(Float.valueOf(partialTicks), IGlowingEntity.class);
            if (ent != null) {
                l = ent.produceColoredLight(partialTicks);
            }
            HandleLightOverrideEvent<Particle> evt = new HandleLightOverrideEvent<Particle>((Particle)particle, partialTicks, l);
            HammerLib.postEvent(evt);
            return evt.getNewLight();
        }).filter((Predicate<ColoredLight>)Predicates.notNull());
    }

    @Override
    public Consumer<FMLClientSetupEvent> addTESR(Type owner, String member, Type tesr) {
        return e -> ReflectionUtil.getStaticFinalField(ReflectionUtil.fetchClass(owner), member).ifPresent(type -> {
            if (type.getRegistryName() == null) {
                HammerLib.LOG.info("Skipping TESR for tile " + type.getRegistryName() + " as it is not registered.");
                return;
            }
            HammerLib.LOG.info("Registering TESR for tile " + type.getRegistryName());
            Class anyTesr = ReflectionUtil.fetchClass(tesr);
            Function<BlockEntityRendererProvider.Context, BlockEntityRenderer> theTesr = null;
            if (IBESR.class.isAssignableFrom(anyTesr)) {
                try {
                    Constructor ctor = anyTesr.getDeclaredConstructor(new Class[0]);
                    ctor.setAccessible(true);
                    TESRBase base = new TESRBase((IBESR)ctor.newInstance(new Object[0]));
                    theTesr = ctx -> base;
                }
                catch (ReflectiveOperationException err) {
                    err.printStackTrace();
                }
            }
            if (theTesr == null) {
                for (Constructor<?> ctr : anyTesr.getDeclaredConstructors()) {
                    try {
                        if (ctr.getParameterCount() == 0) {
                            BlockEntityRenderer r = (BlockEntityRenderer)ctr.newInstance(new Object[0]);
                            theTesr = c -> r;
                            continue;
                        }
                        if (ctr.getParameterCount() != 1 || ctr.getParameterTypes()[0] != BlockEntityRendererProvider.Context.class) continue;
                        theTesr = ctx -> {
                            try {
                                return (BlockEntityRenderer)Cast.cast(ctr.newInstance(ctx));
                            }
                            catch (ReflectiveOperationException err) {
                                err.printStackTrace();
                                return null;
                            }
                        };
                    }
                    catch (ReflectiveOperationException err) {
                        err.printStackTrace();
                    }
                }
            }
            if (theTesr == null) {
                throw new RuntimeException("Unable to find a valid constructor for " + type.getRegistryName() + "'s TESR " + anyTesr);
            }
            Function<BlockEntityRendererProvider.Context, BlockEntityRenderer> finalTheTesr = theTesr;
            BlockEntityRenderers.m_173590_((BlockEntityType)type, ctx -> (BlockEntityRenderer)Cast.cast(finalTheTesr.apply(ctx)));
        });
    }

    @SubscribeEvent
    public void renderWorldLast(RenderLevelLastEvent e) {
        if (!this.renderedWorld) {
            Network.sendToServer(new PacketPlayerReady());
            MinecraftForge.EVENT_BUS.post((Event)new ClientLoadedInEvent());
            this.renderedWorld = true;
        }
    }

    @SubscribeEvent
    public void clientTick(TickEvent.ClientTickEvent e) {
        if (Minecraft.m_91087_().f_91073_ != null) {
            if (!Minecraft.m_91087_().m_91104_()) {
                --this.pingTimer;
                if (this.pingTimer <= 0) {
                    this.pingTimer += 40;
                    Network.sendToServer(new PingServerPacket(System.currentTimeMillis()));
                }
            }
        } else if (this.renderedWorld) {
            this.renderedWorld = false;
            ConfigAdapter.resetClientsideSync();
        }
    }

    @SubscribeEvent
    public void addF3Info(RenderGameOverlayEvent.Pre event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.DEBUG) {
            this.renderF3 = true;
        }
    }

    @SubscribeEvent
    public void addF3Info(RenderGameOverlayEvent.Text f3) {
        if (this.renderF3) {
            ArrayList tip = f3.getLeft();
            tip.add(ChatFormatting.GOLD + "[HammerLib]" + ChatFormatting.RESET + " Ping: ~" + PingServerPacket.lastPingTime + " ms.");
            this.renderF3 = false;
        }
    }

    @Override
    public String getLanguage() {
        return Minecraft.m_91087_().f_91066_.f_92075_;
    }

    @Override
    public Player getClientPlayer() {
        return Minecraft.m_91087_().f_91074_;
    }

    @Override
    public ReloadableResourceManager getResourceManager() {
        if (LogicalSidePredictor.getCurrentLogicalSide() == LogicalSide.CLIENT) {
            return (ReloadableResourceManager)Minecraft.m_91087_().m_91098_();
        }
        return super.getResourceManager();
    }
}

